/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.cards.d.DermotaxiCopyApplier;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.util.functions.CopyApplier;

class DermotaxiCopyEffect
extends OneShotEffect {
    DermotaxiCopyEffect() {
        super(Outcome.Benefit);
        this.staticText = "until end of turn, {this} becomes a copy of the exiled card, except it's a Vehicle artifact in addition to its other types";
    }

    private DermotaxiCopyEffect(DermotaxiCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public DermotaxiCopyEffect copy() {
        return new DermotaxiCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (sourcePermanent == null) {
            return false;
        }
        Card card = game.getCard((UUID)sourcePermanent.getImprinted().get(0));
        if (card == null) {
            return false;
        }
        PermanentCard newBluePrint = new PermanentCard(card, source.getControllerId(), game);
        newBluePrint.assignNewId();
        DermotaxiCopyApplier applier = new DermotaxiCopyApplier();
        applier.apply(game, (MageObject)newBluePrint, source, sourcePermanent.getId());
        CopyEffect copyEffect = new CopyEffect(Duration.EndOfTurn, (MageObject)newBluePrint, sourcePermanent.getId());
        copyEffect.setApplier((CopyApplier)applier);
        game.addEffect((ContinuousEffect)copyEffect, source);
        return true;
    }
}

