/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.costs.SacrificeCost;
import mage.abilities.effects.Effect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;
import mage.watchers.common.DamagedPlayerThisCombatWatcher;

class DescendantsFurySacrificeCost
extends CostImpl
implements SacrificeCost {
    DescendantsFurySacrificeCost() {
        this.text = "sacrifice one of them";
    }

    private DescendantsFurySacrificeCost(DescendantsFurySacrificeCost cost) {
        super((CostImpl)cost);
    }

    public DescendantsFurySacrificeCost copy() {
        return new DescendantsFurySacrificeCost(this);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        DamagedPlayerThisCombatWatcher watcher = (DamagedPlayerThisCombatWatcher)game.getState().getWatcher(DamagedPlayerThisCombatWatcher.class);
        if (watcher == null) {
            return false;
        }
        Player damagedPlayer = game.getPlayer(((Effect)source.getEffects().get(0)).getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || damagedPlayer == null) {
            return false;
        }
        FilterControlledPermanent filter = new FilterControlledPermanent();
        filter.add((Predicate)new PermanentReferenceInCollectionPredicate((Collection)watcher.getPermanents(controller.getId(), damagedPlayer.getId())));
        TargetSacrifice target = new TargetSacrifice(0, 1, (FilterPermanent)filter);
        if (!controller.choose(Outcome.Sacrifice, (Target)target, source, game)) {
            return false;
        }
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        if (permanent.sacrifice(source, game)) {
            source.getEffects().setValue("SACRIFICED_PERMANENT", (Object)permanent);
            return true;
        }
        return false;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        DamagedPlayerThisCombatWatcher watcher = (DamagedPlayerThisCombatWatcher)game.getState().getWatcher(DamagedPlayerThisCombatWatcher.class);
        if (watcher == null) {
            return false;
        }
        Player damagedPlayer = game.getPlayer(((Effect)source.getEffects().get(0)).getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || damagedPlayer == null) {
            return false;
        }
        return watcher.getPermanents(controller.getId(), damagedPlayer.getId()).stream().map(p -> p.getPermanent(game)).anyMatch(p -> p != null && controller.canPaySacrificeCost(p, source, controllerId, game));
    }
}

