/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class DescendantsPathEffect
extends OneShotEffect {
    DescendantsPathEffect() {
        super(Outcome.Discard);
        this.staticText = "reveal the top card of your library. If it's a creature card that shares a creature type with a creature you control, you may cast it without paying its mana cost. If you don't cast it, put it on the bottom of your library";
    }

    private DescendantsPathEffect(DescendantsPathEffect effect) {
        super((OneShotEffect)effect);
    }

    public DescendantsPathEffect copy() {
        return new DescendantsPathEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        controller.revealCards(source, (Cards)new CardsImpl(card), game);
        if (card.isCreature(game) && game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game).stream().anyMatch(permanent -> permanent.shareCreatureTypes(game, (MageObject)card))) {
            CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Card)card);
        }
        if (game.getState().getZone(card.getId()) == Zone.LIBRARY) {
            controller.putCardsOnBottomOfLibrary(card, game, source);
        }
        return true;
    }
}

