/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValueParityPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DesecrateRealityEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterPermanentCard("permanent card with an odd mana value in your graveyard");

    DesecrateRealityEffect() {
        super(Outcome.PutCardInPlay);
    }

    private DesecrateRealityEffect(DesecrateRealityEffect effect) {
        super((OneShotEffect)effect);
    }

    public DesecrateRealityEffect copy() {
        return new DesecrateRealityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(filter);
        target.withNotTarget(true);
        if (controller.choose(this.outcome, (Target)target, source, game)) {
            ReturnFromGraveyardToBattlefieldTargetEffect effect = new ReturnFromGraveyardToBattlefieldTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(target.getFirstTarget(), game));
            effect.apply(game, source);
        }
        return true;
    }

    static {
        filter.add((Predicate)ManaValueParityPredicate.ODD);
    }
}

