/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.counters.CounterType;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class DesecrationDemonEffect
extends OneShotEffect {
    DesecrationDemonEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "any opponent may sacrifice a creature of their choice. If a player does, tap {this} and put a +1/+1 counter on it";
    }

    private DesecrationDemonEffect(DesecrationDemonEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent descrationDemon = game.getPermanent(source.getSourceId());
        if (controller != null && descrationDemon != null) {
            for (UUID opponentId : game.getOpponents(controller.getId())) {
                Player opponent = game.getPlayer(opponentId);
                if (opponent == null) continue;
                FilterControlledPermanent filter = new FilterControlledPermanent("creature to sacrifice");
                filter.add((Predicate)CardType.CREATURE.getPredicate());
                filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
                TargetControlledPermanent target = new TargetControlledPermanent(1, 1, filter, false);
                if (!target.canChoose(opponent.getId(), source, game) || !opponent.chooseUse(Outcome.AIDontUseIt, "Sacrifice a creature to tap " + descrationDemon.getLogName() + "and put a +1/+1 counter on it?", source, game)) continue;
                opponent.choose(Outcome.Sacrifice, (Target)target, source, game);
                Permanent permanent = game.getPermanent(target.getFirstTarget());
                if (permanent == null) continue;
                permanent.sacrifice(source, game);
                game.informPlayers(opponent.getLogName() + " sacrifices " + permanent.getLogName() + " to tap " + descrationDemon.getLogName() + ". A +1/+1 counter was put on it");
                descrationDemon.tap(source, game);
                descrationDemon.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
            }
            return true;
        }
        return false;
    }

    public DesecrationDemonEffect copy() {
        return new DesecrationDemonEffect(this);
    }
}

