/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class DesolationWatcher
extends Watcher {
    private final Set<UUID> tappedForManaThisTurnPlayers = new HashSet<UUID>();

    DesolationWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (game.inCheckPlayableState() || event.getType() != GameEvent.EventType.TAPPED_FOR_MANA) {
            return;
        }
        Permanent permanent = ((TappedForManaEvent)event).getPermanent();
        if (permanent != null && permanent.isLand(game)) {
            this.tappedForManaThisTurnPlayers.add(permanent.getControllerId());
        }
    }

    public Set<UUID> getPlayersTappedForMana() {
        return this.tappedForManaThisTurnPlayers;
    }

    public void reset() {
        super.reset();
        this.tappedForManaThisTurnPlayers.clear();
    }
}

