/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PopulateEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class DeterminedIterationEffect
extends OneShotEffect {
    DeterminedIterationEffect() {
        super(Outcome.Benefit);
        this.staticText = "populate. The token created this way gains haste. Sacrifice it at the beginning of the next end step. <i>(To populate, create a token that's a copy of a creature token you control.)</i>";
    }

    private DeterminedIterationEffect(DeterminedIterationEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeterminedIterationEffect copy() {
        return new DeterminedIterationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        PopulateEffect effect = new PopulateEffect();
        effect.apply(game, source);
        if (effect.getAddedPermanents().isEmpty()) {
            return false;
        }
        game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.Custom).setTargetPointer((TargetPointer)new FixedTargets((Collection)effect.getAddedPermanents(), game)), source);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new SacrificeTargetEffect("sacrifice the token").setTargetPointer((TargetPointer)new FixedTargets((Collection)effect.getAddedPermanents(), game))), source);
        return true;
    }
}

