/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class DevourFleshSacrificeEffect
extends OneShotEffect {
    DevourFleshSacrificeEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Target player sacrifices a creature, then gains life equal to that creature's toughness";
    }

    private DevourFleshSacrificeEffect(DevourFleshSacrificeEffect effect) {
        super((OneShotEffect)effect);
    }

    public DevourFleshSacrificeEffect copy() {
        return new DevourFleshSacrificeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        if (game.getBattlefield().count(TargetSacrifice.makeFilter((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE), player.getId(), source, game) > 0) {
            TargetSacrifice target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);
            player.choose(Outcome.Sacrifice, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent != null) {
                int gainLife = permanent.getToughness().getValue();
                permanent.sacrifice(source, game);
                game.processAction();
                player.gainLife(gainLife, game, source);
            } else {
                return false;
            }
        }
        return true;
    }
}

