/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.d.DevoutInvocation;
import mage.constants.Outcome;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.AngelToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class DevoutInvocationEffect
extends OneShotEffect {
    DevoutInvocationEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "Tap any number of untapped creatures you control. Create a 4/4 white Angel creature token with flying for each creature tapped this way";
    }

    private DevoutInvocationEffect(DevoutInvocationEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetControlledPermanent target = new TargetControlledPermanent(0, Integer.MAX_VALUE, (FilterControlledPermanent)DevoutInvocation.filter, true);
        controller.choose(this.outcome, (Target)target, source, game);
        if (target.getTargets().isEmpty()) {
            return false;
        }
        int tappedAmount = 0;
        for (UUID permanentId : target.getTargets()) {
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null || !permanent.tap(source, game)) continue;
            ++tappedAmount;
        }
        if (tappedAmount > 0) {
            AngelToken angelToken = new AngelToken();
            angelToken.putOntoBattlefield(tappedAmount, game, source, source.getControllerId());
        }
        return true;
    }

    public DevoutInvocationEffect copy() {
        return new DevoutInvocationEffect(this);
    }
}

