/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.common.LookLibraryAndPickControllerEffect;
import mage.abilities.effects.common.RevealLibraryPickControllerEffect;
import mage.cards.Cards;
import mage.constants.PutCards;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;

class DihadaFilterEffect
extends RevealLibraryPickControllerEffect {
    private static final FilterCard legendaryfilter = new FilterCard("legendary cards");

    DihadaFilterEffect() {
        super(4, Integer.MAX_VALUE, legendaryfilter, PutCards.HAND, PutCards.GRAVEYARD, false);
        this.staticText = "Reveal the top four cards of your library. Put any number of legendary cards from among them into your hand and the rest into your graveyard. Create a Treasure token for each card put into your graveyard this way";
    }

    private DihadaFilterEffect(DihadaFilterEffect effect) {
        super((LookLibraryAndPickControllerEffect)effect);
    }

    public DihadaFilterEffect copy() {
        return new DihadaFilterEffect(this);
    }

    protected boolean actionWithPickedCards(Game game, Ability source, Player player, Cards pickedCards, Cards otherCards) {
        super.actionWithPickedCards(game, source, player, pickedCards, otherCards);
        otherCards.retainZone(Zone.GRAVEYARD, game);
        if (!otherCards.isEmpty()) {
            new TreasureToken().putOntoBattlefield(otherCards.size(), game, source, player.getId());
        }
        return true;
    }

    static {
        legendaryfilter.add((Predicate)SuperType.LEGENDARY.getPredicate());
    }
}

