/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;

class DimensionalBreachReturnEffect
extends OneShotEffect {
    private final Set<MageObjectReference> morSet = new HashSet<MageObjectReference>();

    DimensionalBreachReturnEffect(Set<MageObjectReference> morSet) {
        super(Outcome.PutCardInPlay);
        this.morSet.addAll(morSet);
    }

    private DimensionalBreachReturnEffect(DimensionalBreachReturnEffect effect) {
        super((OneShotEffect)effect);
        this.morSet.addAll(effect.morSet);
    }

    public DimensionalBreachReturnEffect copy() {
        return new DimensionalBreachReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(this.morSet.stream().map(mor -> mor.getCard(game)).filter(Objects::nonNull).filter(c -> c.isOwnedBy(game.getActivePlayerId())).collect(Collectors.toSet()));
        if (cards.isEmpty()) {
            return false;
        }
        if (cards.size() > 1) {
            TargetCardInExile target = new TargetCardInExile(StaticFilters.FILTER_CARD);
            target.withNotTarget(true);
            player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
            cards.clear();
            cards.add((Object)target.getFirstTarget());
        }
        return player.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
    }
}

