/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class DiminishingReturnsEffect
extends OneShotEffect {
    DiminishingReturnsEffect() {
        super(Outcome.Neutral);
        this.staticText = "You exile the top ten cards of your library. Then each player draws up to seven cards.";
    }

    private DiminishingReturnsEffect(DiminishingReturnsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.moveCards(controller.getLibrary().getTopCards(game, 10), Zone.EXILED, source, game);
            game.processAction();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                int amount = player.getAmount(0, 7, "How many cards to draw (up to 7)?", source, game);
                player.drawCards(amount, source, game);
            }
        }
        return true;
    }

    public DiminishingReturnsEffect copy() {
        return new DiminishingReturnsEffect(this);
    }
}

