/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CounterTargetEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.d.DimirCharmEffect;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.filter.FilterPermanent;
import mage.filter.FilterSpell;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.TargetPlayer;
import mage.target.TargetSpell;

public final class DimirCharm
extends CardImpl {
    private static final FilterCreaturePermanent filterCreature = new FilterCreaturePermanent("creature with power 2 or less");
    private static final FilterSpell filterSorcery = new FilterSpell("sorcery spell");

    public DimirCharm(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{U}{B}");
        this.getSpellAbility().addEffect((Effect)new CounterTargetEffect());
        this.getSpellAbility().addTarget((Target)new TargetSpell(filterSorcery));
        Mode mode1 = new Mode((Effect)new DestroyTargetEffect());
        mode1.addTarget((Target)new TargetPermanent((FilterPermanent)filterCreature));
        this.getSpellAbility().addMode(mode1);
        Mode mode2 = new Mode((Effect)new DimirCharmEffect());
        mode2.addTarget((Target)new TargetPlayer());
        this.getSpellAbility().addMode(mode2);
    }

    private DimirCharm(DimirCharm card) {
        super((CardImpl)card);
    }

    public DimirCharm copy() {
        return new DimirCharm(this);
    }

    static {
        filterCreature.add((Predicate)new PowerPredicate(ComparisonType.FEWER_THAN, 3));
        filterSorcery.add((Predicate)CardType.SORCERY.getPredicate());
    }
}

