/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class DimirStrandcatcherWatcher
extends Watcher {
    private final Map<UUID, Integer> map = new HashMap<UUID, Integer>();

    DimirStrandcatcherWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ZONE_CHANGE) {
            return;
        }
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (Zone.GRAVEYARD.match(zEvent.getToZone()) && !Zone.BATTLEFIELD.match(zEvent.getFromZone())) {
            this.map.compute(game.getOwnerId(zEvent.getTargetId()), CardUtil::setOrIncrementValue);
        }
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    static int getValue(Game game, Ability source) {
        return ((DimirStrandcatcherWatcher)game.getState().getWatcher(DimirStrandcatcherWatcher.class)).map.getOrDefault(source.getControllerId(), 0);
    }
}

