/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterControlledLandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.token.DinOfTheFireherdToken;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DinOfTheFireherdEffect
extends OneShotEffect {
    private static final FilterControlledCreaturePermanent blackCreatureFilter = new FilterControlledCreaturePermanent("black creatures you control");
    private static final FilterControlledCreaturePermanent redCreatureFilter = new FilterControlledCreaturePermanent("red creatures you control");

    public DinOfTheFireherdEffect() {
        super(Outcome.Neutral);
        this.staticText = "create a 5/5 black and red Elemental creature token. Target opponent sacrifices a creature for each black creature you control, then sacrifices a land for each red creature you control";
    }

    private DinOfTheFireherdEffect(DinOfTheFireherdEffect effect) {
        super((OneShotEffect)effect);
    }

    public DinOfTheFireherdEffect copy() {
        return new DinOfTheFireherdEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        DinOfTheFireherdToken token = new DinOfTheFireherdToken();
        boolean applied = token.putOntoBattlefield(1, game, source, source.getControllerId());
        int blackCreaturesControllerControls = game.getBattlefield().countAll((FilterPermanent)blackCreatureFilter, source.getControllerId(), game);
        int redCreaturesControllerControls = game.getBattlefield().countAll((FilterPermanent)redCreatureFilter, source.getControllerId(), game);
        Player targetOpponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetOpponent != null) {
            SacrificeEffect effect = new SacrificeEffect((FilterPermanent)new FilterControlledCreaturePermanent(), blackCreaturesControllerControls, "Target Opponent");
            effect.setTargetPointer((TargetPointer)new FixedTarget(targetOpponent.getId()));
            effect.apply(game, source);
            SacrificeEffect effect2 = new SacrificeEffect((FilterPermanent)new FilterControlledLandPermanent(), redCreaturesControllerControls, "Target Opponent");
            effect2.setTargetPointer((TargetPointer)new FixedTarget(targetOpponent.getId()));
            effect2.apply(game, source);
            applied = true;
        }
        return applied;
    }

    static {
        blackCreatureFilter.add((Predicate)new ColorPredicate(ObjectColor.BLACK));
        redCreatureFilter.add((Predicate)new ColorPredicate(ObjectColor.RED));
    }
}

