/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.DiscoverEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DinosaurEggEffect
extends OneShotEffect {
    DinosaurEggEffect() {
        super(Outcome.Benefit);
        this.staticText = "discover X, where X is its toughness";
    }

    private DinosaurEggEffect(DinosaurEggEffect effect) {
        super((OneShotEffect)effect);
    }

    public DinosaurEggEffect copy() {
        return new DinosaurEggEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (player == null || permanent == null) {
            return false;
        }
        DiscoverEffect.doDiscover((Player)player, (int)Math.max(0, permanent.getToughness().getValue()), (Game)game, (Ability)source);
        return true;
    }
}

