/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.common.AttacksTriggeredAbility;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageWithPowerFromSourceToAnotherTargetEffect;
import mage.abilities.effects.common.DoWhenCostPaid;
import mage.cards.d.DireBlunderbussSacrificeCost;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DireBlunderbussGainAbilityEffect
extends ContinuousEffectImpl {
    DireBlunderbussGainAbilityEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "and has \"Whenever this creature attacks, you may sacrifice an artifact other than {this}. When you do, this creature deals damage equal to its power to target creature.\"";
    }

    protected DireBlunderbussGainAbilityEffect(DireBlunderbussGainAbilityEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public DireBlunderbussGainAbilityEffect copy() {
        return new DireBlunderbussGainAbilityEffect(this);
    }

    public void init(Ability source, Game game) {
        Permanent equipment;
        super.init(source, game);
        if (this.getAffectedObjectsSet() && (equipment = game.getPermanentOrLKIBattlefield(source.getSourceId())) != null && equipment.getAttachedTo() != null) {
            this.setTargetPointer((TargetPointer)new FixedTarget(equipment.getAttachedTo(), game.getState().getZoneChangeCounter(equipment.getAttachedTo())));
        }
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = null;
        if (this.getAffectedObjectsSet()) {
            permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (permanent == null) {
                this.discard();
                return true;
            }
        } else {
            Permanent equipment = game.getPermanent(source.getSourceId());
            if (equipment != null && equipment.getAttachedTo() != null) {
                permanent = game.getPermanentOrLKIBattlefield(equipment.getAttachedTo());
            }
        }
        if (permanent == null) {
            return true;
        }
        Ability ability = this.makeAbility(game, source);
        ability.getEffects().setValue("attachedPermanent", (Object)game.getPermanent(source.getSourceId()));
        permanent.addAbility(ability, source.getSourceId(), game);
        return true;
    }

    protected Ability makeAbility(Game game, Ability source) {
        ReflexiveTriggeredAbility reflexive = new ReflexiveTriggeredAbility((Effect)new DamageWithPowerFromSourceToAnotherTargetEffect("this creature"), false);
        reflexive.addTarget((Target)new TargetCreaturePermanent());
        return new AttacksTriggeredAbility((Effect)new DoWhenCostPaid(reflexive, (Cost)new DireBlunderbussSacrificeCost(source, game), "Sacrifice an artifact other than the equipment?"), false);
    }
}

