/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.SacrificeCost;
import mage.abilities.costs.UseAttachedCost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.MageObjectReferencePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DireBlunderbussSacrificeCost
extends UseAttachedCost
implements SacrificeCost {
    private final SacrificeTargetCost sacrificeCost;

    DireBlunderbussSacrificeCost(Ability source, Game game) {
        this.setMageObjectReference(source, game);
        FilterControlledArtifactPermanent filter = new FilterControlledArtifactPermanent();
        filter.add(Predicates.not((Predicate)new MageObjectReferencePredicate(this.mageObjectReference)));
        this.sacrificeCost = new SacrificeTargetCost((FilterPermanent)filter);
    }

    private DireBlunderbussSacrificeCost(DireBlunderbussSacrificeCost cost) {
        super((UseAttachedCost)cost);
        this.sacrificeCost = cost.sacrificeCost.copy();
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return this.sacrificeCost.canPay(ability, source, controllerId, game);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        if (this.mageObjectReference == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return this.paid;
        }
        this.paid = this.sacrificeCost.pay(ability, game, source, controllerId, noMana, costToPay);
        return this.paid;
    }

    public DireBlunderbussSacrificeCost copy() {
        return new DireBlunderbussSacrificeCost(this);
    }

    public String getText() {
        return "sacrifice an artifact other than " + this.name;
    }
}

