/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class DireFleetRavagerEffect
extends OneShotEffect {
    DireFleetRavagerEffect() {
        super(Outcome.Detriment);
        this.staticText = "each player loses a third of their life, rounded up";
    }

    private DireFleetRavagerEffect(DireFleetRavagerEffect effect) {
        super((OneShotEffect)effect);
    }

    public DireFleetRavagerEffect copy() {
        return new DireFleetRavagerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                int lifeToLose = (int)Math.ceil((double)player.getLife() / 3.0);
                player.loseLife(lifeToLose, game, source, false);
            }
            return true;
        }
        return false;
    }
}

