/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInPlayTargetControllerEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.common.TargetCardInLibrary;

class DireStrainRampageEffect
extends OneShotEffect {
    DireStrainRampageEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target artifact, enchantment, or land. If a land was destroyed this way, its controller may search their library for up to two basic land cards, put them onto the battlefield tapped, then shuffle. Otherwise, its controller may search their library for a basic land card, put it onto the battlefield tapped, then shuffle";
    }

    private DireStrainRampageEffect(DireStrainRampageEffect effect) {
        super((OneShotEffect)effect);
    }

    public DireStrainRampageEffect copy() {
        return new DireStrainRampageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        boolean landTargeted = permanent.isLand(game);
        boolean destroyed = permanent.destroy(source, game, false);
        game.processAction();
        TargetCardInLibrary target = landTargeted && destroyed ? new TargetCardInLibrary(0, 2, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LANDS) : new TargetCardInLibrary(1, 1, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
        return new SearchLibraryPutInPlayTargetControllerEffect(target, true, Outcome.PutLandInPlay, "its controller").apply(game, source);
    }
}

