/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DiregrafColossusEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    public DiregrafColossusEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "{this} enters with a +1/+1 counter on it for each Zombie card in your graveyard";
    }

    private DiregrafColossusEffect(DiregrafColossusEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (permanent != null && player != null) {
            int amount = 0;
            if ((amount += player.getGraveyard().count(filter, game)) > 0) {
                permanent.addCounters(CounterType.P1P1.createInstance(amount), source.getControllerId(), source, game);
            }
            return true;
        }
        return false;
    }

    public DiregrafColossusEffect copy() {
        return new DiregrafColossusEffect(this);
    }

    static {
        filter.add((Predicate)SubType.ZOMBIE.getPredicate());
    }
}

