/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.ZombieDecayedToken;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

class DiregrafHordeEffect
extends OneShotEffect {
    DiregrafHordeEffect() {
        super(Outcome.Benefit);
        this.staticText = "create two 2/2 black Zombie creature tokens with decayed. When you do, exile up to two target cards from graveyards";
    }

    private DiregrafHordeEffect(DiregrafHordeEffect effect) {
        super((OneShotEffect)effect);
    }

    public DiregrafHordeEffect copy() {
        return new DiregrafHordeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (!new ZombieDecayedToken().putOntoBattlefield(2, game, source, source.getControllerId())) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new ExileTargetEffect(), false, "exile up to two target cards from graveyards");
        ability.addTarget((Target)new TargetCardInGraveyard(0, 2));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

