/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPlayer;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DiscerningFinancierEffect
extends OneShotEffect {
    private static final FilterPlayer filter = new FilterPlayer("another player");

    DiscerningFinancierEffect() {
        super(Outcome.Detriment);
        this.staticText = "choose another player. That player gains control of target Treasure you control";
    }

    private DiscerningFinancierEffect(DiscerningFinancierEffect effect) {
        super((OneShotEffect)effect);
    }

    public DiscerningFinancierEffect copy() {
        return new DiscerningFinancierEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetPlayer target = new TargetPlayer(filter);
        target.withNotTarget(true);
        Permanent treasure = game.getPermanent(source.getFirstTarget());
        if (treasure == null || !target.canChoose(source.getControllerId(), source, game)) {
            return false;
        }
        target.choose(Outcome.Benefit, source.getControllerId(), source.getSourceId(), source, game);
        Player chosen = game.getPlayer(target.getFirstTarget());
        if (chosen == null) {
            return false;
        }
        game.addEffect(new GainControlTargetEffect(Duration.WhileOnBattlefield, true, chosen.getId()).setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game)), source);
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.NOT_YOU.getPlayerPredicate());
    }
}

