/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class DiscipleOfCaelusNinFirstEffect
extends OneShotEffect {
    DiscipleOfCaelusNinFirstEffect() {
        super(Outcome.Benefit);
        this.staticText = "starting with you, each player chooses up to five permanents they control. All permanents other than {this} that weren't chosen this way phase out";
    }

    private DiscipleOfCaelusNinFirstEffect(DiscipleOfCaelusNinFirstEffect effect) {
        super((OneShotEffect)effect);
    }

    public DiscipleOfCaelusNinFirstEffect copy() {
        return new DiscipleOfCaelusNinFirstEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet<UUID> toKeep = new HashSet<UUID>();
        if (source.getSourcePermanentIfItStillExists(game) != null) {
            toKeep.add(source.getSourceId());
        }
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            TargetPermanent target = new TargetPermanent(0, 5, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT, true);
            player.choose(this.outcome, (Target)target, source, game);
            toKeep.addAll(target.getTargets());
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(source.getControllerId(), game)) {
            if (toKeep.contains(permanent.getId())) continue;
            permanent.phaseOut(game);
        }
        return true;
    }
}

