/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.common.DiscardTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInHand;
import mage.target.common.TargetCardInLibrary;

class DiscipleOfDeceitEffect
extends OneShotEffect {
    public DiscipleOfDeceitEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may discard a nonland card. If you do, search your library for a card with the same mana value as that card, reveal it, put it into your hand, then shuffle";
    }

    private DiscipleOfDeceitEffect(DiscipleOfDeceitEffect effect) {
        super((OneShotEffect)effect);
    }

    public DiscipleOfDeceitEffect copy() {
        return new DiscipleOfDeceitEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        MageObject mageObject = game.getObject(source);
        if (player != null && mageObject != null) {
            DiscardTargetCost cost = new DiscardTargetCost(new TargetCardInHand((FilterCard)new FilterNonlandCard()));
            String message = "Discard a nonland card to search your library?";
            if (cost.canPay(source, source, source.getControllerId(), game) && player.chooseUse(Outcome.Detriment, message, source, game) && cost.pay(source, game, source, source.getControllerId(), false, null)) {
                Card card = game.getCard(cost.getTargets().getFirstTarget());
                if (card == null) {
                    return false;
                }
                String targetName = "card with mana value of " + card.getManaValue();
                FilterCard filter = new FilterCard(targetName);
                filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, card.getManaValue()));
                return new SearchLibraryPutInHandEffect(new TargetCardInLibrary(filter), true).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

