/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class DiscipleOfFreyaliseEffect
extends OneShotEffect {
    DiscipleOfFreyaliseEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may sacrifice another creature. If you do, you gain X life and draw X cards, where X is that creature's power";
    }

    private DiscipleOfFreyaliseEffect(DiscipleOfFreyaliseEffect effect) {
        super((OneShotEffect)effect);
    }

    public DiscipleOfFreyaliseEffect copy() {
        return new DiscipleOfFreyaliseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        SacrificeTargetCost cost = new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_ANOTHER_CREATURE);
        if (!(cost.canPay(source, source, source.getControllerId(), game) && player.chooseUse(this.outcome, "Sacrifice another creature?", source, game) && cost.pay(source, game, source, source.getControllerId(), true))) {
            return false;
        }
        int xValue = cost.getPermanents().stream().filter(Objects::nonNull).mapToInt(p -> p.getPower().getValue()).sum();
        if (xValue <= 0) {
            return true;
        }
        new GainLifeEffect(xValue).apply(game, source);
        new DrawCardSourceControllerEffect(xValue).apply(game, source);
        return true;
    }
}

