/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.discard.LookTargetHandChooseDiscardEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DiscordantDirgeEffect
extends OneShotEffect {
    DiscordantDirgeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Look at target opponent's hand and choose up to X cards from it, where X is the number of verse counters on {this}. That player discards those cards";
    }

    private DiscordantDirgeEffect(DiscordantDirgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent discordantDirge = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (discordantDirge == null) {
            return false;
        }
        int verseCounters = discordantDirge.getCounters(game).getCount(CounterType.VERSE);
        return new LookTargetHandChooseDiscardEffect(true, verseCounters).apply(game, source);
    }

    public DiscordantDirgeEffect copy() {
        return new DiscordantDirgeEffect(this);
    }
}

