/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class DismantleEffect
extends OneShotEffect {
    DismantleEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target artifact. If that artifact had counters on it, put that many +1/+1 counters or charge counters on an artifact you control";
    }

    private DismantleEffect(DismantleEffect effect) {
        super((OneShotEffect)effect);
    }

    public DismantleEffect copy() {
        return new DismantleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null) {
            if (permanent != null) {
                TargetControlledPermanent target;
                int counterCount = 0;
                counterCount = permanent.getCounters(game).values().stream().mapToInt(Counter::getCount).sum();
                permanent.destroy(source, game, false);
                if (counterCount > 0 && (target = new TargetControlledPermanent(1, 1, (FilterControlledPermanent)new FilterControlledArtifactPermanent("an artifact you control"), true)).canChoose(controller.getId(), source, game)) {
                    controller.chooseTarget(Outcome.Benefit, (Target)target, source, game);
                    Permanent artifact = game.getPermanent(target.getFirstTarget());
                    Counter counter = controller.chooseUse(Outcome.BoostCreature, "Choose which kind of counters to add", null, "+1/+1 counters", "Charge counters", source, game) ? CounterType.P1P1.createInstance(counterCount) : CounterType.CHARGE.createInstance(counterCount);
                    if (artifact != null) {
                        artifact.addCounters(counter, source.getControllerId(), source, game);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

