/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GreatestAmongPermanentsValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;

class DispersalShieldEffect
extends OneShotEffect {
    DispersalShieldEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell if its mana value is less than or equal to the greatest mana value among permanents you control";
    }

    private DispersalShieldEffect(DispersalShieldEffect effect) {
        super((OneShotEffect)effect);
    }

    public DispersalShieldEffect copy() {
        return new DispersalShieldEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int amount = GreatestAmongPermanentsValue.MANAVALUE_CONTROLLED_PERMANENTS.calculate(game, source, (Effect)this);
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell != null && spell.getManaValue() <= amount) {
            return game.getStack().counter(source.getFirstTarget(), source, game);
        }
        return false;
    }
}

