/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.continuous.AddCardSubTypeTargetEffect;
import mage.abilities.effects.common.continuous.AddCardTypeTargetEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessTargetEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

class DisplacedDinosaursEntersBattlefieldEffect
extends ReplacementEffectImpl {
    DisplacedDinosaursEntersBattlefieldEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature);
        this.staticText = "As a historic permanent you control enters, it becomes a 7/7 Dinosaur creature in addition to its other types. <i>(Artifacts, legendaries, and Sagas are historic.)</i>";
    }

    private DisplacedDinosaursEntersBattlefieldEffect(DisplacedDinosaursEntersBattlefieldEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent historic = ((EntersTheBattlefieldEvent)event).getTarget();
        return historic != null && historic.isControlledBy(source.getControllerId()) && historic.isHistoric(game) && !event.getTargetId().equals(source.getSourceId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent historic = ((EntersTheBattlefieldEvent)event).getTarget();
        if (historic != null) {
            FixedTarget blueprintTarget = new FixedTarget(historic.getId(), historic.getZoneChangeCounter(game) + 1);
            AddCardTypeTargetEffect creatureEffect = new AddCardTypeTargetEffect(Duration.Custom, new CardType[]{CardType.CREATURE});
            creatureEffect.setTargetPointer(blueprintTarget.copy());
            game.addEffect((ContinuousEffect)creatureEffect, source);
            AddCardSubTypeTargetEffect dinosaurEffect = new AddCardSubTypeTargetEffect(SubType.DINOSAUR, Duration.Custom);
            dinosaurEffect.setTargetPointer(blueprintTarget.copy());
            game.addEffect((ContinuousEffect)dinosaurEffect, source);
            SetBasePowerToughnessTargetEffect sevenSevenEffect = new SetBasePowerToughnessTargetEffect(7, 7, Duration.Custom);
            sevenSevenEffect.setTargetPointer(blueprintTarget.copy());
            game.addEffect((ContinuousEffect)sevenSevenEffect, source);
        }
        return false;
    }

    public DisplacedDinosaursEntersBattlefieldEffect copy() {
        return new DisplacedDinosaursEntersBattlefieldEffect(this);
    }
}

