/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DivergentTransformationsEffect
extends OneShotEffect {
    DivergentTransformationsEffect() {
        super(Outcome.Detriment);
        this.staticText = "Exile two target creatures. For each of those creatures, its controller reveals cards from the top of their library until they reveal a creature card, puts that card onto the battlefield, then shuffles the rest into their library";
    }

    private DivergentTransformationsEffect(DivergentTransformationsEffect effect) {
        super((OneShotEffect)effect);
    }

    public DivergentTransformationsEffect copy() {
        return new DivergentTransformationsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            ArrayList<UUID> controllerList = new ArrayList<UUID>();
            HashSet<Permanent> toExile = new HashSet<Permanent>();
            for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent == null) continue;
                toExile.add(permanent);
                controllerList.add(permanent.getControllerId());
            }
            controller.moveCards(toExile, Zone.EXILED, source, game);
            for (UUID playerId : controllerList) {
                Player player = game.getPlayer(playerId);
                if (player == null || !player.getLibrary().hasCards()) continue;
                CardsImpl toReveal = new CardsImpl();
                for (Card card : player.getLibrary().getCards(game)) {
                    toReveal.add(card);
                    if (!card.isCreature(game)) continue;
                    player.revealCards(source, (Cards)toReveal, game);
                    player.moveCards(card, Zone.BATTLEFIELD, source, game);
                    toReveal.remove(card);
                    break;
                }
                if (toReveal.isEmpty()) continue;
                player.shuffleLibrary(source, game);
            }
            return true;
        }
        return false;
    }
}

