/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class DivineCongregationEffect
extends OneShotEffect {
    DivineCongregationEffect() {
        super(Outcome.Benefit);
        this.staticText = "You gain 2 life for each creature target player controls";
    }

    private DivineCongregationEffect(DivineCongregationEffect effect) {
        super((OneShotEffect)effect);
    }

    public DivineCongregationEffect copy() {
        return new DivineCongregationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        if (controller != null && player != null) {
            int critters = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, player.getId(), game).size();
            controller.gainLife(2 * critters, game, source);
        }
        return true;
    }
}

