/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectData;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class DivineDeflectionPreventDamageTargetEffect
extends PreventionEffectImpl {
    DivineDeflectionPreventDamageTargetEffect(Duration duration) {
        super(duration, Integer.MIN_VALUE, false, true);
        this.staticText = "Prevent the next X damage that would be dealt to you and/or permanents you control this turn. If damage is prevented this way, {this} deals that much damage to any target";
    }

    private DivineDeflectionPreventDamageTargetEffect(DivineDeflectionPreventDamageTargetEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public DivineDeflectionPreventDamageTargetEffect copy() {
        return new DivineDeflectionPreventDamageTargetEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        PreventionEffectData preventionData = this.preventDamageAction(event, source, game);
        int prevented = preventionData.getPreventedDamage();
        if (prevented > 0) {
            Player player;
            UUID dealDamageTo = source.getFirstTarget();
            Permanent permanent = game.getPermanent(dealDamageTo);
            if (permanent != null) {
                game.informPlayers("Dealing " + prevented + " to " + permanent.getName() + " instead");
                permanent.damage(prevented, source.getSourceId(), source, game, false, true);
            }
            if ((player = game.getPlayer(dealDamageTo)) != null) {
                game.informPlayers("Dealing " + prevented + " to " + player.getLogName() + " instead");
                player.damage(prevented, source.getSourceId(), source, game);
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!this.used && super.applies(event, source, game)) {
            Permanent permanent;
            if (this.amountToPrevent == Integer.MIN_VALUE) {
                this.amountToPrevent = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
            }
            if ((permanent = game.getPermanent(event.getTargetId())) != null && permanent.isControlledBy(source.getControllerId())) {
                return true;
            }
            return source.isControlledBy(event.getTargetId());
        }
        return false;
    }
}

