/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class DivinersPortentEffect
extends OneShotEffect {
    DivinersPortentEffect() {
        super(Outcome.Benefit);
        this.staticText = "scry X, then draw X cards";
    }

    private DivinersPortentEffect(DivinersPortentEffect effect) {
        super((OneShotEffect)effect);
    }

    public DivinersPortentEffect copy() {
        return new DivinersPortentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (player == null || xValue < 1) {
            return false;
        }
        player.scry(xValue, source, game);
        player.drawCards(xValue, source, game);
        return true;
    }
}

