/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.DiscardTargetCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseACardNameEffect;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

public final class DiviningWitch
extends CardImpl {
    public DiviningWitch(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{1}{B}");
        this.subtype.add((Object)SubType.HUMAN);
        this.subtype.add((Object)SubType.SPELLSHAPER);
        this.power = new MageInt(1);
        this.toughness = new MageInt(1);
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new DiviningWitchEffect(), (Cost)new ManaCostsImpl("{1}{B}"));
        ability.addCost((Cost)new TapSourceCost());
        ability.addCost((Cost)new DiscardTargetCost(new TargetCardInHand()));
        this.addAbility((Ability)ability);
    }

    private DiviningWitch(DiviningWitch card) {
        super((CardImpl)card);
    }

    public DiviningWitch copy() {
        return new DiviningWitch(this);
    }

    private static class DiviningWitchEffect
    extends OneShotEffect {
        DiviningWitchEffect() {
            super(Outcome.Benefit);
            this.staticText = "choose a card name. Exile the top six cards of your library, then reveal cards from the top of your library until you reveal a card with the chosen name. Put that card into your hand and exile all other cards revealed this way";
        }

        private DiviningWitchEffect(DiviningWitchEffect effect) {
            super((OneShotEffect)effect);
        }

        public DiviningWitchEffect copy() {
            return new DiviningWitchEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            Player controller = game.getPlayer(source.getControllerId());
            MageObject sourceObject = game.getObject(source);
            if (controller == null || sourceObject == null) {
                return false;
            }
            String cardName = ChooseACardNameEffect.TypeOfName.ALL.getChoice(controller, game, source, false);
            controller.moveCards(controller.getLibrary().getTopCards(game, 6), Zone.EXILED, source, game);
            CardsImpl cardsToReveal = new CardsImpl();
            Card cardToHand = null;
            for (Card card : controller.getLibrary().getCards(game)) {
                cardsToReveal.add(card);
                if (!CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game)) continue;
                cardToHand = card;
                break;
            }
            controller.moveCards(cardToHand, Zone.HAND, source, game);
            controller.revealCards(sourceObject.getIdName(), (Cards)cardsToReveal, game);
            cardsToReveal.remove(cardToHand);
            controller.moveCards((Cards)cardsToReveal, Zone.EXILED, source, game);
            return true;
        }
    }
}

