/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DizzyingGazeEffect
extends OneShotEffect {
    DizzyingGazeEffect() {
        super(Outcome.Benefit);
        this.staticText = "enchanted creature deals 1 damage to target creature with flying";
    }

    private DizzyingGazeEffect(DizzyingGazeEffect effect) {
        super((OneShotEffect)effect);
    }

    public DizzyingGazeEffect copy() {
        return new DizzyingGazeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        return creature != null && Optional.ofNullable(source.getSourcePermanentOrLKI(game)).map(Permanent::getAttachedTo).filter(permanentId -> creature.damage(1, permanentId, source, game) > 0).isPresent();
    }
}

