/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DjeruAndHazoretEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCreatureCard("a legendary creature card");

    DjeruAndHazoretEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top six cards of your library. You may exile a legendary creature card from among them. Put the rest on the bottom of your library in a random order. Until end of turn, you may cast the exiled card without paying its mana cost";
    }

    private DjeruAndHazoretEffect(DjeruAndHazoretEffect effect) {
        super((OneShotEffect)effect);
    }

    public DjeruAndHazoretEffect copy() {
        return new DjeruAndHazoretEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 6));
        TargetCardInLibrary target = new TargetCardInLibrary(0, 1, filter);
        player.choose(Outcome.PlayForFree, (Cards)cards, (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card != null) {
            player.moveCards(card, Zone.EXILED, source, game);
            game.addEffect(new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, TargetController.YOU, Duration.Custom, true).setTargetPointer((TargetPointer)new FixedTarget(card, game)), source);
        }
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }

    static {
        filter.add((Predicate)SuperType.LEGENDARY.getPredicate());
    }
}

