/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.UntapTargetEffect;
import mage.abilities.effects.common.combat.BlocksIfAbleTargetEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.SecondTargetPointer;
import mage.target.targetpointer.TargetPointer;

class DomineeringWillEffect
extends OneShotEffect {
    DomineeringWillEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target player gains control of up to three target nonattacking creatures until end of turn. Untap those creatures. They block this turn if able";
    }

    private DomineeringWillEffect(DomineeringWillEffect effect) {
        super((OneShotEffect)effect);
    }

    public DomineeringWillEffect copy() {
        return new DomineeringWillEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer != null) {
            GainControlTargetEffect effect = new GainControlTargetEffect(Duration.EndOfTurn, targetPlayer.getId());
            effect.setTargetPointer((TargetPointer)new SecondTargetPointer());
            effect.setText("Target player gains control of up to three target nonattacking creatures until end of turn");
            game.addEffect((ContinuousEffect)effect, source);
            UntapTargetEffect effect2 = new UntapTargetEffect();
            effect2.setTargetPointer((TargetPointer)new SecondTargetPointer());
            effect2.setText("Untap those creatures");
            effect2.apply(game, source);
            BlocksIfAbleTargetEffect effect3 = new BlocksIfAbleTargetEffect(Duration.EndOfTurn);
            effect3.setTargetPointer((TargetPointer)new SecondTargetPointer());
            effect3.setText("They block this turn if able");
            game.addEffect((ContinuousEffect)effect3, source);
            return true;
        }
        return false;
    }
}

