/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class DoomsdayEffect
extends OneShotEffect {
    DoomsdayEffect() {
        super(Outcome.LoseLife);
        this.staticText = "Search your library and graveyard for five cards and exile the rest. Put the chosen cards on top of your library in any order";
    }

    private DoomsdayEffect(DoomsdayEffect effect) {
        super((OneShotEffect)effect);
    }

    public DoomsdayEffect copy() {
        return new DoomsdayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl allCards = new CardsImpl();
            allCards.addAll((Collection)controller.getLibrary().getCardList());
            allCards.addAll((Collection)controller.getGraveyard());
            int number = Math.min(5, allCards.size());
            TargetCard target = new TargetCard(number, number, Zone.ALL, new FilterCard());
            if (controller.choose(Outcome.Benefit, (Cards)allCards, target, source, game)) {
                CardsImpl toLibrary = new CardsImpl((Collection)target.getTargets());
                allCards.removeAll((Collection)toLibrary);
                controller.moveCards((Cards)allCards, Zone.EXILED, source, game);
                controller.putCardsOnTopOfLibrary((Cards)toLibrary, game, source, true);
            }
            return true;
        }
        return false;
    }
}

