/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class DoppelgangEffect
extends OneShotEffect {
    DoppelgangEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each of X target permanents, create X tokens that are copies of that permanent";
    }

    private DoppelgangEffect(DoppelgangEffect effect) {
        super((OneShotEffect)effect);
    }

    public DoppelgangEffect copy() {
        return new DoppelgangEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (xValue < 1) {
            return false;
        }
        for (UUID permanentId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null) continue;
            new CreateTokenCopyTargetEffect(null, null, false, xValue).setSavedPermanent(permanent).apply(game, source);
        }
        return true;
    }
}

