/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.regex.Pattern;
import mage.MageObject;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.SplitCard;
import mage.constants.SpellAbilityType;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.stack.Spell;

class DoubleHeaderPredicate
implements Predicate<MageObject> {
    public boolean apply(MageObject input, Game game) {
        String name = input.getName();
        if (input instanceof SplitCard) {
            return this.hasTwoWords(((SplitCard)input).getLeftHalfCard().getName()) || this.hasTwoWords(((SplitCard)input).getRightHalfCard().getName());
        }
        if (input instanceof ModalDoubleFacedCard) {
            return this.hasTwoWords(((ModalDoubleFacedCard)input).getLeftHalfCard().getName()) || this.hasTwoWords(((ModalDoubleFacedCard)input).getRightHalfCard().getName());
        }
        if (input instanceof Spell && ((Spell)input).getSpellAbility().getSpellAbilityType() == SpellAbilityType.SPLIT_FUSED) {
            SplitCard card = (SplitCard)((Spell)input).getCard();
            return this.hasTwoWords(card.getLeftHalfCard().getName()) || this.hasTwoWords(card.getRightHalfCard().getName());
        }
        if (name.contains(" // ")) {
            String leftName = name.substring(0, name.indexOf(" // "));
            String rightName = name.substring(name.indexOf(" // ") + 4);
            return this.hasTwoWords(leftName) || this.hasTwoWords(rightName);
        }
        return this.hasTwoWords(name);
    }

    private boolean hasTwoWords(String str) {
        return Pattern.compile("\\s+").split(str).length == 2;
    }

    public String toString() {
        return "";
    }
}

