/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.ArrayList;
import java.util.List;
import mage.ConditionalMana;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.game.Game;
import mage.players.ManaPool;
import mage.players.Player;

class DoublingCubeEffect
extends ManaEffect {
    DoublingCubeEffect() {
        this.staticText = "Double the amount of each type of unspent mana you have";
    }

    private DoublingCubeEffect(DoublingCubeEffect effect) {
        super((ManaEffect)effect);
    }

    public List<Mana> getNetMana(Game game, Mana possibleManaInPool, Ability source) {
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        netMana.add(new Mana(possibleManaInPool.getWhite(), possibleManaInPool.getBlue(), possibleManaInPool.getBlack(), possibleManaInPool.getRed(), possibleManaInPool.getGreen(), 0, possibleManaInPool.getAny(), possibleManaInPool.getColorless()));
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        Player controller;
        if (game != null && (controller = game.getPlayer(source.getControllerId())) != null) {
            ManaPool pool = controller.getManaPool();
            int blackMana = pool.getBlack();
            int whiteMana = pool.getWhite();
            int blueMana = pool.getBlue();
            int greenMana = pool.getGreen();
            int redMana = pool.getRed();
            int colorlessMana = pool.getColorless();
            for (ConditionalMana conditionalMana : pool.getConditionalMana()) {
                blackMana += conditionalMana.getBlack();
                whiteMana += conditionalMana.getWhite();
                blueMana += conditionalMana.getBlue();
                greenMana += conditionalMana.getGreen();
                redMana += conditionalMana.getRed();
                colorlessMana += conditionalMana.getColorless();
            }
            return new Mana(whiteMana, blueMana, blackMana, redMana, greenMana, 0, 0, colorlessMana);
        }
        return new Mana();
    }

    public DoublingCubeEffect copy() {
        return new DoublingCubeEffect(this);
    }
}

