/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.PreventDamageByTargetEffect;
import mage.abilities.effects.common.PreventDamageToTargetEffect;
import mage.abilities.effects.common.cost.SpellsCostIncreasingAllEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.TargetController;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class DovinHandOfControl
extends CardImpl {
    private static final FilterCard filter = new FilterCard("Artifact, instant, and sorcery spells");

    public DovinHandOfControl(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.PLANESWALKER}, "{2}{W/U}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.DOVIN);
        this.setStartingLoyalty(5);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new SpellsCostIncreasingAllEffect(1, filter, TargetController.OPPONENT)));
        LoyaltyAbility ability = new LoyaltyAbility((Effect)new PreventDamageToTargetEffect(Duration.UntilYourNextTurn).setText("Until your next turn, prevent all damage that would be dealt to"), -1);
        ability.addEffect((Effect)new PreventDamageByTargetEffect(Duration.UntilYourNextTurn, false).setText("and dealt by target permanent an opponent controls"));
        ability.addTarget((Target)new TargetPermanent(StaticFilters.FILTER_OPPONENTS_PERMANENT));
        this.addAbility((Ability)ability);
    }

    private DovinHandOfControl(DovinHandOfControl card) {
        super((CardImpl)card);
    }

    public DovinHandOfControl copy() {
        return new DovinHandOfControl(this);
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.INSTANT.getPredicate(), CardType.SORCERY.getPredicate()}));
    }
}

