/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class DragonKamisEggEffect
extends OneShotEffect {
    DragonKamisEggEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may cast a creature spell from among cards you own in exile with hatching counters on them without paying its mana cost";
    }

    private DragonKamisEggEffect(DragonKamisEggEffect effect) {
        super((OneShotEffect)effect);
    }

    public DragonKamisEggEffect copy() {
        return new DragonKamisEggEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        game.getExile().getCardsOwned(game, player.getId()).stream().filter(Objects::nonNull).filter(card -> card.getCounters(game).containsKey(CounterType.HATCHLING)).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        return !cards.isEmpty() && CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Cards)cards, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
    }
}

