/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DragonclawStrikeEffect
extends OneShotEffect {
    DragonclawStrikeEffect() {
        super(Outcome.Benefit);
        this.staticText = "double the power and toughness of target creature you control until end of turn";
    }

    private DragonclawStrikeEffect(DragonclawStrikeEffect effect) {
        super((OneShotEffect)effect);
    }

    public DragonclawStrikeEffect copy() {
        return new DragonclawStrikeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        game.addEffect(new BoostTargetEffect(permanent.getPower().getValue(), permanent.getToughness().getValue()).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        return true;
    }
}

