/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class DragonsDiscipleEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("Dragon card from your hand");

    public DragonsDiscipleEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may reveal a Dragon card from your hand. If you do or if you control a Dragon, {this} enters with a +1/+1 counter on it";
    }

    private DragonsDiscipleEffect(DragonsDiscipleEffect effect) {
        super((OneShotEffect)effect);
    }

    public DragonsDiscipleEffect copy() {
        return new DragonsDiscipleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentEntering(source.getSourceId());
        if (controller != null && sourcePermanent != null) {
            Card card;
            TargetCardInHand target = new TargetCardInHand(filter);
            if (!target.possibleTargets(source.getControllerId(), source, game).isEmpty() && controller.chooseUse(this.outcome, "Reveal a Dragon card from your hand?", source, game) && controller.chooseTarget(this.outcome, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
                CardsImpl revealedCards = new CardsImpl(card);
                controller.revealCards(source, sourcePermanent.getIdName(), (Cards)revealedCards, game);
                sourcePermanent.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
                return true;
            }
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents(source.getControllerId())) {
                if (permanent == null || !permanent.hasSubtype(SubType.DRAGON, game)) continue;
                sourcePermanent.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
                return true;
            }
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.DRAGON.getPredicate());
    }
}

