/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

public final class DragonsoulKnight
extends CardImpl {
    public DragonsoulKnight(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{2}{R}");
        this.subtype.add((Object)SubType.HUMAN);
        this.subtype.add((Object)SubType.KNIGHT);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);
        this.addAbility((Ability)FirstStrikeAbility.getInstance());
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new DragonsoulKnightEffect(), (Cost)new ManaCostsImpl("{W}{U}{B}{R}{G}"));
        BoostSourceEffect effect = new BoostSourceEffect(5, 3, Duration.EndOfTurn);
        effect.setText(", gets +5/+3");
        ability.addEffect((Effect)effect);
        effect = new GainAbilitySourceEffect((Ability)FlyingAbility.getInstance(), Duration.EndOfTurn);
        effect.setText(", and gains flying");
        ability.addEffect((Effect)effect);
        effect = new GainAbilitySourceEffect((Ability)TrampleAbility.getInstance(), Duration.EndOfTurn);
        effect.setText("and trample");
        ability.addEffect((Effect)effect);
        this.addAbility((Ability)ability);
    }

    private DragonsoulKnight(DragonsoulKnight card) {
        super((CardImpl)card);
    }

    public DragonsoulKnight copy() {
        return new DragonsoulKnight(this);
    }

    private static class DragonsoulKnightEffect
    extends ContinuousEffectImpl {
        private DragonsoulKnightEffect() {
            super(Duration.EndOfTurn, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.BecomeCreature);
            this.staticText = "Until end of turn, {this} becomes a Dragon";
        }

        private DragonsoulKnightEffect(DragonsoulKnightEffect effect) {
            super((ContinuousEffectImpl)effect);
        }

        public DragonsoulKnightEffect copy() {
            return new DragonsoulKnightEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            Permanent permanent = game.getPermanent(source.getSourceId());
            if (permanent == null) {
                return false;
            }
            permanent.removeAllCreatureTypes(game);
            permanent.addSubType(game, new SubType[]{SubType.DRAGON});
            return true;
        }
    }
}

