/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class DrainLifeEffect
extends OneShotEffect {
    DrainLifeEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage to any target. You gain life equal to the damage dealt, but not more life than the player's life total before the damage was dealt, the planeswalker's loyalty before the damage was dealt, or the creature's toughness.";
    }

    private DrainLifeEffect(DrainLifeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int amount;
        int lifetogain = amount = ((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue();
        if (amount == 0) {
            return true;
        }
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            if (permanent.isCreature(game)) {
                lifetogain = Math.min(permanent.getToughness().getValue(), lifetogain);
            } else if (permanent.isPlaneswalker(game)) {
                lifetogain = Math.min(permanent.getCounters(game).getCount(CounterType.LOYALTY), lifetogain);
            } else {
                return false;
            }
            permanent.damage(amount, source.getSourceId(), source, game);
        } else {
            Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (player == null) {
                return false;
            }
            lifetogain = Math.min(player.getLife(), lifetogain);
            player.damage(amount, source.getSourceId(), source, game);
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.gainLife(lifetogain, game, source);
        return true;
    }

    public DrainLifeEffect copy() {
        return new DrainLifeEffect(this);
    }
}

