/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.TargetPlayerActivatesAllManaAbilitiesEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.ManaPoolItem;
import mage.players.Player;

class DrainPowerEffect
extends OneShotEffect {
    DrainPowerEffect() {
        super(Outcome.PutManaInPool);
        this.staticText = "Target player activates a mana ability of each land they control. Then that player loses all unspent mana and you add the mana lost this way";
    }

    private DrainPowerEffect(DrainPowerEffect effect) {
        super((OneShotEffect)effect);
    }

    public DrainPowerEffect copy() {
        return new DrainPowerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (targetPlayer == null) {
            return false;
        }
        new TargetPlayerActivatesAllManaAbilitiesEffect().setTargetPointer(this.getTargetPointer().copy()).apply(game, source);
        List manaItems = targetPlayer.getManaPool().getManaItems();
        targetPlayer.getManaPool().emptyPool(game);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return true;
        }
        for (ManaPoolItem manaPoolItem : manaItems) {
            controller.getManaPool().addMana((Mana)(manaPoolItem.isConditional() ? manaPoolItem.getConditionalMana() : manaPoolItem.getMana()), game, source, Duration.EndOfTurn.equals((Object)manaPoolItem.getDuration()));
        }
        return true;
    }
}

