/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.common.CounterTargetEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.stack.Spell;

class DrainingWhelkEffect
extends CounterTargetEffect {
    DrainingWhelkEffect() {
        this.staticText = "counter target spell. Put X +1/+1 counters on {this}, where X is that spell's mana value";
    }

    private DrainingWhelkEffect(DrainingWhelkEffect effect) {
        super((CounterTargetEffect)effect);
    }

    public DrainingWhelkEffect copy() {
        return new DrainingWhelkEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell targetSpell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (targetSpell != null) {
            int spellCMC = targetSpell.getManaValue();
            super.apply(game, source);
            new AddCountersSourceEffect(CounterType.P1P1.createInstance(spellCMC)).apply(game, source);
            return true;
        }
        return false;
    }
}

